/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.util.vector.Vector3f;

public class BlockModelUtils {
    private static final float VERTEX_COORD_ACCURACY = 1.0E-6f;

    public static boq makeModelCube(String spriteName, int tintIndex) {
        bmi sprite = Config.getMinecraft().T().a(spriteName);
        return BlockModelUtils.makeModelCube(sprite, tintIndex);
    }

    public static boq makeModelCube(bmi sprite, int tintIndex) {
        ArrayList generalQuads = new ArrayList();
        cq[] facings = cq.n;
        ArrayList faceQuads = new ArrayList();
        for (int i = 0; i < facings.length; ++i) {
            cq facing = facings[i];
            ArrayList<bgg> quads = new ArrayList<bgg>();
            quads.add(BlockModelUtils.makeBakedQuad(facing, sprite, tintIndex));
            faceQuads.add(quads);
        }
        bow bakedModel = new bow(generalQuads, faceQuads, true, true, sprite, bgr.a);
        return bakedModel;
    }

    public static boq joinModelsCube(boq modelBase, boq modelAdd) {
        ArrayList generalQuads = new ArrayList();
        generalQuads.addAll(modelBase.a());
        generalQuads.addAll(modelAdd.a());
        cq[] facings = cq.n;
        ArrayList faceQuads = new ArrayList();
        for (int i = 0; i < facings.length; ++i) {
            cq facing = facings[i];
            ArrayList quads = new ArrayList();
            quads.addAll(modelBase.a(facing));
            quads.addAll(modelAdd.a(facing));
            faceQuads.add(quads);
        }
        boolean ao = modelBase.b();
        boolean builtIn = modelBase.d();
        bmi sprite = modelBase.e();
        bgr transforms = modelBase.f();
        bow bakedModel = new bow(generalQuads, faceQuads, ao, builtIn, sprite, transforms);
        return bakedModel;
    }

    public static bgg makeBakedQuad(cq facing, bmi sprite, int tintIndex) {
        Vector3f posFrom = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f posTo = new Vector3f(16.0f, 16.0f, 16.0f);
        bgk uv = new bgk(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0);
        bgi face = new bgi(facing, tintIndex, "#" + facing.l(), uv);
        bor modelRotation = bor.a;
        bgj partRotation = null;
        boolean uvLocked = false;
        boolean shade = true;
        bgo faceBakery = new bgo();
        bgg quad = faceBakery.a(posFrom, posTo, face, sprite, facing, modelRotation, partRotation, uvLocked, shade);
        return quad;
    }

    public static boq makeModel(String modelName, String spriteOldName, String spriteNewName) {
        bmh textureMap = Config.getMinecraft().T();
        bmi spriteOld = textureMap.getSpriteSafe(spriteOldName);
        bmi spriteNew = textureMap.getSpriteSafe(spriteNewName);
        return BlockModelUtils.makeModel(modelName, spriteOld, spriteNew);
    }

    public static boq makeModel(String modelName, bmi spriteOld, bmi spriteNew) {
        if (spriteOld == null || spriteNew == null) {
            return null;
        }
        bou modelManager = Config.getModelManager();
        if (modelManager == null) {
            return null;
        }
        bov mrl = new bov(modelName, "normal");
        boq model = modelManager.a(mrl);
        if (model == null || model == modelManager.a()) {
            return null;
        }
        boq modelNew = ModelUtils.duplicateModel(model);
        cq[] faces = cq.n;
        for (int i = 0; i < faces.length; ++i) {
            cq face = faces[i];
            List quads = modelNew.a(face);
            BlockModelUtils.replaceTexture(quads, spriteOld, spriteNew);
        }
        List quadsGeneral = modelNew.a();
        BlockModelUtils.replaceTexture(quadsGeneral, spriteOld, spriteNew);
        return modelNew;
    }

    private static void replaceTexture(List<bgg> quads, bmi spriteOld, bmi spriteNew) {
        ArrayList<Object> quadsNew = new ArrayList<Object>();
        for (bgg quad : quads) {
            if (quad.getSprite() != spriteOld) {
                quadsNew.add(quad);
                break;
            }
            bgn quadNew = new bgn(quad, spriteNew);
            quadsNew.add(quadNew);
        }
        quads.clear();
        quads.addAll(quadsNew);
    }

    public static void snapVertexPosition(Vector3f pos) {
        pos.setX(BlockModelUtils.snapVertexCoord(pos.getX()));
        pos.setY(BlockModelUtils.snapVertexCoord(pos.getY()));
        pos.setZ(BlockModelUtils.snapVertexCoord(pos.getZ()));
    }

    private static float snapVertexCoord(float x) {
        if (x > -1.0E-6f && x < 1.0E-6f) {
            return 0.0f;
        }
        if (x > 0.999999f && x < 1.000001f) {
            return 1.0f;
        }
        return x;
    }

    public static aug getOffsetBoundingBox(aug aabb, afh.a offsetType, cj pos) {
        int x = pos.n();
        int z = pos.p();
        long k = (long)(x * 3129871) ^ (long)z * 116129781L;
        k = k * k * 42317861L + k * 11L;
        double dx = ((double)((float)(k >> 16 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dz = ((double)((float)(k >> 24 & 0xFL) / 15.0f) - 0.5) * 0.5;
        double dy = 0.0;
        if (offsetType == afh.a.c) {
            dy = ((double)((float)(k >> 20 & 0xFL) / 15.0f) - 1.0) * 0.2;
        }
        return aabb.c(dx, dy, dz);
    }
}

