/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.inputfix;

import java.lang.reflect.Method;
import lain.mods.inputfix.InputFixSetup;
import lain.mods.inputfix.interfaces.IGuiScreen;
import lain.mods.inputfix.utils.ReflectionHelper;
import net.minecraft.client.gui.GuiScreen;
import org.lwjgl.input.Keyboard;

public class GuiScreenFix {
    private static final ThreadLocal<Proxy> proxies = new ThreadLocal<Proxy>(){

        @Override
        protected Proxy initialValue() {
            return new Proxy();
        }
    };
    private static final Method keyTyped = ReflectionHelper.findMethod(GuiScreen.class, new String[]{"func_73869_a", "keyTyped"}, new Class[]{Character.TYPE, Integer.TYPE});

    public static void handleKeyboardInput(GuiScreen gui) {
        Proxy p = proxies.get().setGui(gui);
        if (InputFixSetup.impl != null) {
            InputFixSetup.impl.handleKeyboardInput(p);
        } else if (Keyboard.getEventKeyState()) {
            p.keyTyped(Keyboard.getEventCharacter(), Keyboard.getEventKey());
        }
        gui.field_146297_k.func_152348_aa();
    }

    private static class Proxy
    implements IGuiScreen {
        private GuiScreen gui;

        private Proxy() {
        }

        @Override
        public void keyTyped(char c, int k) {
            try {
                if (this.gui != null) {
                    keyTyped.invoke((Object)this.gui, Character.valueOf(c), k);
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        public Proxy setGui(GuiScreen gui) {
            this.gui = gui;
            return this;
        }
    }
}

