/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.inputfix.utils;

public class OSDetector {
    String osName = System.getProperty("os.name");

    public static OS detectOS() {
        OSDetector detector = new OSDetector();
        if (detector.isWindows()) {
            return OS.Windows;
        }
        if (detector.isLinux()) {
            return OS.Linux;
        }
        if (detector.isMac()) {
            return OS.Mac;
        }
        return OS.Unknown;
    }

    private OSDetector() {
    }

    boolean isLinux() {
        return this.osName.startsWith("Linux") || this.osName.startsWith("FreeBSD") || this.osName.startsWith("SunOS") || this.osName.startsWith("Unix");
    }

    boolean isMac() {
        return this.osName.startsWith("Mac OS X") || this.osName.startsWith("Darwin");
    }

    boolean isWindows() {
        return this.osName.startsWith("Windows");
    }

    public static enum OS {
        Windows,
        Linux,
        Mac,
        Unknown;

    }
}

